/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.toolkit.runtime.VWTrkLaunchStep;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepAssignmentPanel;
import filenet.vw.toolkit.runtime.property.VWStepParameterPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepRoutingPanel;
import filenet.vw.toolkit.runtime.property.VWStepRulePanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWLaunchStepPropPanel
extends VWBaseStepPropPanel {
    private VWTrkLaunchStep m_launchStep = null;
    private JPanel m_topPanel;
    private JPanel m_generalPanel;
    private VWStepAssignmentPanel m_assignmentsPanel;
    private VWStepParameterPanel m_parameterPanel;
    private VWToolbarBorder m_commentsBorder = null;
    private VWToolbarBorder m_stepProcessorBorder = null;
    private String m_comments = null;
    private String m_response = null;
    private VWParticipant m_originator = null;
    private Date m_launchDate = null;
    private String m_stepProcessor = null;
    private JTextField m_launchDateUI;
    private JTextField m_responseUI;
    private JTextField m_originatorUI;
    private JTextArea m_commentsUI;
    private JTextField m_stepProcessUI;
    private DateFormat m_dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2);

    public VWLaunchStepPropPanel(VWStepPropPanel stepPropPanel, Frame parentFrame) {
        super(stepPropPanel, parentFrame);
    }

    protected void createTabs() {
        this.m_generalPanel = new JPanel();
        this.m_parameterPanel = new VWStepParameterPanel(this.m_parentFrame, this);
        this.m_assignmentsPanel = new VWStepAssignmentPanel(this.m_parentFrame, this);
        this.m_routingPanel = new VWStepRoutingPanel(this.m_parentFrame, this);
        if (this.getAreRulesEnabled()) {
            this.m_rulesPanel = new VWStepRulePanel(this.m_parentFrame, this);
        }
        this.m_tabs = new Vector();
        this.m_tabs.add(this.m_generalPanel);
        this.m_tabs.add(this.m_parameterPanel);
        this.m_tabs.add(this.m_assignmentsPanel);
        this.m_tabs.add(this.m_routingPanel);
        if (this.m_rulesPanel != null) {
            this.m_tabs.add(this.m_rulesPanel);
        }
    }

    public void initialize() {
        if (this.isTrackerDataInitialized()) {
            this.setSelectionChanged(4);
            this.initData();
            this.updateTabs();
            this.updateSelectedTabNow();
        }
    }

    protected void setupTopPanel() {
        if (this.m_bLayoutInitialized) {
            return;
        }
        this.setupInstructionBorder(VWResource.s_instructions);
        this.m_topPanel = this.m_instructionBorder;
        this.m_instructionsUI.setText(this.m_instructions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupLayout() {
        if (this.m_bLayoutInitialized) {
            return;
        }
        try {
            this.setLayout(new BorderLayout());
            this.setupTopPanel();
            this.add((Component)this.m_topPanel, "First");
            this.setupTabbedPane();
            this.add((Component)this.m_stepTabbedPane, "Center");
            this.m_bLayoutInitialized = true;
        }
        finally {
            this.doneUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupTabbedPane() {
        if (this.m_bLayoutInitialized) {
            return;
        }
        try {
            this.setUpdating();
            super.setupTabbedPane();
            if (this.m_stepTabbedPane != null) {
                this.setupGeneralTab();
                this.m_stepTabbedPane.addTab(VWResource.s_general, null, this.m_generalPanel, null);
                this.m_stepTabbedPane.addTab(VWResource.s_parameters, null, this.m_parameterPanel, null);
                this.m_stepTabbedPane.addTab(VWResource.s_assignments, null, this.m_assignmentsPanel, null);
                this.m_stepTabbedPane.addTab(VWResource.s_routing, null, this.m_routingPanel, null);
                if (this.m_rulesPanel != null) {
                    this.m_stepTabbedPane.addTab(VWResource.s_rules, null, this.m_rulesPanel, null);
                }
            }
        }
        finally {
            this.doneUpdating();
        }
    }

    private void setupGeneralTab() {
        GridBagConstraints c = new GridBagConstraints();
        Insets noInsets = new Insets(0, 0, 0, 0);
        Insets insets = new Insets(0, 6, 0, 0);
        this.m_generalPanel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        this.m_generalPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_launched)), c);
        c.gridx = 1;
        c.insets = insets;
        c.gridwidth = 0;
        c.fill = 2;
        this.m_launchDateUI = new JTextField();
        this.m_launchDateUI.setEditable(false);
        this.m_launchDateUI.setBorder(null);
        this.m_generalPanel.add((Component)this.m_launchDateUI, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = noInsets;
        this.m_generalPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_originator)), c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = insets;
        c.gridwidth = 0;
        VWParticipantItem pItem = new VWParticipantItem(this.m_originator);
        this.m_originatorUI = new JTextField(pItem.getDisplayName());
        this.m_originatorUI.setEditable(false);
        this.m_originatorUI.setBorder(null);
        this.m_generalPanel.add((Component)this.m_originatorUI, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = noInsets;
        c.weightx = 0.0;
        c.fill = 0;
        this.m_generalPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_response)), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = insets;
        c.gridwidth = 0;
        this.m_responseUI = new JTextField(this.m_response);
        this.m_responseUI.setEditable(false);
        this.m_responseUI.setBorder(null);
        this.m_generalPanel.add((Component)this.m_responseUI, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 0;
        c.fill = 1;
        c.insets = noInsets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.m_commentsUI = new JTextArea(this.m_comments);
        this.m_commentsBorder = this.setupTextAreaBorder(VWResource.s_comments, this.m_commentsUI);
        this.m_generalPanel.add((Component)this.m_commentsBorder, c);
        c.gridy = 4;
        c.weighty = 0.0;
        c.fill = 2;
        this.m_stepProcessorBorder = new VWToolbarBorder(VWResource.s_stepProcessor, 0);
        JPanel panel = this.m_stepProcessorBorder.getClientPanel();
        panel.setLayout(new BorderLayout());
        this.m_stepProcessUI = new JTextField();
        if (this.m_stepProcessor != null) {
            this.m_stepProcessUI.setText(this.m_stepProcessor);
        }
        this.m_stepProcessUI.setEditable(false);
        panel.add((Component)this.m_stepProcessUI, "Center");
        this.m_generalPanel.add((Component)this.m_stepProcessorBorder, c);
    }

    protected void updateDataWithSelectedStep() {
        this.updateTabs();
    }

    protected void clearAllData() {
    }

    protected void clearAllControls() {
    }

    public void propertyChange(VWPropertyChangeEvent event) {
    }

    protected void updateDisplay() {
    }

    protected void refreshTabs() {
    }

    protected void initData() {
        if (this.isTrackerDataInitialized()) {
            this.m_launchStep = this.m_trackerDataModel.getLaunchStep();
            if (this.m_launchStep != null) {
                VWStepProcessorInfo stepProcessor;
                VWStepDefinition definition = this.m_launchStep.getStepDefinition();
                this.m_instructions = definition.getDescription();
                if (this.m_instructionsUI != null) {
                    this.m_instructionsUI.setText(this.m_instructions);
                }
                this.m_launchDate = this.m_launchStep.getLaunchDate();
                if (this.m_launchDateUI != null && this.m_launchDate != null) {
                    this.m_launchDateUI.setText(this.m_dateTimeFormatter.format(this.m_launchDate));
                }
                this.m_response = this.m_launchStep.getResponse();
                if (this.m_responseUI != null) {
                    this.m_responseUI.setText(this.m_response);
                }
                this.m_originator = this.m_trackerDataModel.getOriginator();
                if (this.m_originatorUI != null) {
                    VWParticipantItem pItem = new VWParticipantItem(this.m_originator);
                    this.m_originatorUI.setText(pItem.getDisplayName());
                }
                this.m_comments = this.m_launchStep.getComments();
                if (this.m_commentsUI != null) {
                    this.m_commentsUI.setText(this.m_comments);
                }
                if ((stepProcessor = this.m_launchStep.getStepProcessor()) != null) {
                    this.m_stepProcessor = stepProcessor.getName();
                    this.m_stepProcessUI.setText(this.m_stepProcessor);
                }
            }
        }
    }

    public void removeReferences() {
        super.removeReferences();
        this.m_launchStep = null;
        if (this.m_topPanel != null) {
            this.m_topPanel.removeAll();
            this.m_topPanel = null;
        }
        if (this.m_generalPanel != null) {
            this.m_generalPanel.removeAll();
            this.m_generalPanel = null;
        }
        if (this.m_assignmentsPanel != null) {
            this.m_assignmentsPanel.removeReferences();
            this.m_assignmentsPanel = null;
        }
        if (this.m_parameterPanel != null) {
            this.m_parameterPanel.removeReferences();
            this.m_parameterPanel = null;
        }
        if (this.m_commentsBorder != null) {
            this.m_commentsBorder.removeReferences();
            this.m_commentsBorder = null;
        }
        if (this.m_stepProcessorBorder != null) {
            this.m_stepProcessorBorder.removeReferences();
            this.m_stepProcessorBorder = null;
        }
        this.m_comments = null;
        this.m_response = null;
        this.m_originator = null;
        this.m_launchDate = null;
        this.m_stepProcessor = null;
        this.m_launchDateUI = null;
        this.m_responseUI = null;
        this.m_originatorUI = null;
        this.m_commentsUI = null;
        this.m_stepProcessUI = null;
        this.removeAll();
    }
}

